import { Component, ElementRef, OnInit, ViewChild, ViewEncapsulation } from "@angular/core";
import { Scheduler, SchedulerStatic } from "@dhx/trial-scheduler";
import { EventService } from "../services/event.service";


@Component({
    encapsulation: ViewEncapsulation.None,
    selector: "scheduler",
    providers: [EventService],
    styleUrls: ["scheduler.component.css"],
    templateUrl: "scheduler.component.html"
})


export class SchedulerComponent implements OnInit {
    @ViewChild("scheduler_here", { static: true }) schedulerContainer: ElementRef;
    private _scheduler?: SchedulerStatic;
    constructor(private eventService: EventService) { }

    ngOnInit() {
        let scheduler = Scheduler.getSchedulerInstance();
        scheduler.config.date_format = "%Y-%m-%d %H:%i";
        scheduler.plugins({
            timeline: true,
            limit: true
        });

        scheduler.locale.labels["timeline_tab"] = "Timeline";
        const sections = [];
        for (let i = 1; i <= 1000; i++) {
            sections.push({ key: i, label: `Apartment ${i}` });
        }

        scheduler.createTimelineView({
            name:	"timeline",
            x_unit:	"day",
            x_date:	"%d %M",
            x_step:	1,
            x_size: 365,
            x_start: 0,
            x_length: 30,
            y_unit:	sections,
            scrollable: true,
            y_property:	"section_id",
            render:"bar",
        });
        const timelineList = [];
        for (let i = 1; i <= 1000; i++) {
            timelineList.push(i);
        }
        scheduler.addMarkedTimespan({
            days: [0, 6],
            zones: "fullday",
            type: "dhx_time_block", // will act as blocked section
            sections: {
                timeline: timelineList,
            }
        });
        scheduler.init(this.schedulerContainer.nativeElement, new Date(2026, 6, 1), "timeline");
        scheduler.parse([
            { "id":1, "start_date": "2026-06-29 09:00", "end_date": "2026-06-30 08:00", "text":"Richard", "section_id": 1},
            { "id":2,"start_date": "2026-06-29 10:00", "end_date": "2026-07-05 9:00", "text":"John", "section_id": 2},
            { "id":3,"start_date": "2026-06-29 10:00", "end_date": "2026-06-31 9:00", "text":"Lisa", "section_id": 3, "unchangeable": 1},
            { "id":4,"start_date": "2026-06-29 09:00", "end_date": "2026-06-30 15:00", "text":"Jeff", "section_id": 4},
            { "id":5,"start_date": "2026-06-30 11:00", "end_date": "2026-07-03 15:00", "text":"Ann", "section_id": 1, "unchangeable": 1},
            { "id":6, "start_date": "2026-07-06 12:00", "end_date": "2026-07-07 15:00", "text":"Elisabeth", "section_id": 2}
        ]);
        this._scheduler = scheduler;
    }
    
    ngOnDestroy() {
        if (this._scheduler) this._scheduler.destructor();
    }
}